/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.j2me.midp.runtimeV2;

import com.symbian.j2me.framework.Framework;
import com.symbian.j2me.midp.runtimeV2.MIDletSuite;
import com.symbian.j2me.midp.runtimeV2.SecurityDialogDismissed;
import com.symbian.j2me.midp.runtimeV2.SecurityPolicy;
import com.symbian.j2me.net.URI;
import java.util.Hashtable;
import java.util.Vector;

final class Security {
    private SecurityPolicy iPolicy;
    private Hashtable iGrantedPermissions;
    private Hashtable iDeniedPermissions;
    private Hashtable iUserPermissions;
    private static Security sInstance;

    public static void ensureAutoLaunchPermission(String aOperation, String[] aArgs) throws SecurityException {
        sInstance.ensureAutoLaunchPermissionInternal(aOperation, aArgs);
    }

    private static URI newURI(String aURI) {
        URI uri = null;
        try {
            uri = new URI(aURI);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uri;
    }

    int driveForRoot(String aRoot) {
        return this.iPolicy.driveForRoot(aRoot);
    }

    boolean driveAccessible(int aDrive) {
        return this.iPolicy.driveAccessible(aDrive);
    }

    String rootForDrive(int aDrive) {
        return this.iPolicy.rootForDrive(aDrive);
    }

    int pathAccess(int aDrive, String aPath) {
        return this.iPolicy.pathAccess(aDrive, aPath);
    }

    String[] rootDirectoryList(int aDrive) {
        return this.iPolicy.rootDirectoryList(aDrive);
    }

    String mapPath(int aDrive, String aPath) {
        return this.iPolicy.mapPath(aDrive, aPath);
    }

    synchronized int checkPermission(String aPermission) {
        return 1;
    }

    private synchronized void ensureAutoLaunchPermissionInternal(String aOperation, String[] aArgs) throws SecurityException {
    }

    synchronized int getUserPermissionDoNotPrompt(String aPermission) {
        int result = 1;
        return result;
    }

    synchronized void ensurePermission(String aPermissionName, String aOperation, String[] aArgs) throws SecurityException {
    }

    void ensureConnectionAccess(String aURI) {
        this.ensureConnectionAccess(new URI(aURI, false));
    }

    synchronized void ensureConnectionAccess(URI aURI) throws SecurityException {
    }

    synchronized void ensureConnectionPermission(URI aURI, String aPermissionName, String aOperation, String[] aArgs) throws SecurityException {
        if (aURI != null) {
            this.ensureConnectionAccess(aURI);
        }
        this.ensurePermission(aPermissionName, aOperation, aArgs);
    }

    private boolean getUserAutoLaunchPermission(String aPermission, String aOperation, String[] aArgs) {
        boolean havePermission = false;
        int userPermission = this.iPolicy.getUserAutoLaunchPermission(aPermission, aOperation, aArgs);
        switch (userPermission) {
            case 0: {
                this.iUserPermissions.remove(aPermission);
                this.iDeniedPermissions.put(aPermission, aPermission);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.iUserPermissions.remove(aPermission);
                this.iGrantedPermissions.put(aPermission, aPermission);
                havePermission = true;
                break;
            }
            case 3: {
                havePermission = true;
            }
        }
        return havePermission;
    }

    private boolean getUserPermission(String aPermission, String aOperation, String[] aArgs) {
        boolean havePermission = false;
        int userPermission = this.iPolicy.getUserPermission(aPermission, aOperation, aArgs);
        switch (userPermission) {
            case 0: {
                this.iUserPermissions.remove(aPermission);
                this.iDeniedPermissions.put(aPermission, aPermission);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.iUserPermissions.remove(aPermission);
                this.iGrantedPermissions.put(aPermission, aPermission);
                havePermission = true;
                break;
            }
            case 3: {
                havePermission = true;
                break;
            }
            case 1001: {
                throw new SecurityDialogDismissed();
            }
        }
        return havePermission;
    }

    private static void deny(String aPermission) {
        throw new SecurityException("Permission = ".concat(aPermission));
    }

    static Security initialize(Framework aFramework, MIDletSuite aMIDletSuite, SecurityPolicy aPolicy) throws SecurityException {
        sInstance = new Security(aPolicy);
        sInstance.initialize(aMIDletSuite);
        return sInstance;
    }

    static Security initializeUntrusted(Framework aFramework, MIDletSuite aMIDletSuite, SecurityPolicy aPolicy) {
        sInstance = new Security(aPolicy);
        sInstance.initializeUntrusted(aMIDletSuite);
        return sInstance;
    }

    private Security(SecurityPolicy aPolicy) {
        this.iPolicy = aPolicy;
        this.iGrantedPermissions = new Hashtable();
        this.iDeniedPermissions = new Hashtable();
        this.iUserPermissions = new Hashtable();
    }

    private void initialize(MIDletSuite aMIDletSuite) {
        this.initializePermissions(aMIDletSuite.getRequestedPermissions());
    }

    private void initializeUntrusted(MIDletSuite aMIDletSuite) {
        String permission;
        String[] permissions = this.iPolicy.getGrantedPermissions();
        int permissionCount = permissions.length;
        int i = 0;
        while (i < permissionCount) {
            permission = permissions[i];
            this.iGrantedPermissions.put(permission, permission);
            ++i;
        }
        permissions = this.iPolicy.getDeniedPermissions();
        permissionCount = permissions.length;
        i = 0;
        while (i < permissionCount) {
            permission = permissions[i];
            this.iDeniedPermissions.put(permission, permission);
            ++i;
        }
        permissions = this.iPolicy.getUserPermissions();
        permissionCount = permissions.length;
        i = 0;
        while (i < permissionCount) {
            permission = permissions[i];
            this.iUserPermissions.put(permission, permission);
            ++i;
        }
    }

    private void initializePermissions(Vector aRequestedPermissions) {
        this.initializePermissionTable(this.iGrantedPermissions, this.iPolicy.getGrantedPermissions(), aRequestedPermissions);
        this.initializePermissionTable(this.iDeniedPermissions, this.iPolicy.getDeniedPermissions(), aRequestedPermissions);
        this.initializePermissionTable(this.iUserPermissions, this.iPolicy.getUserPermissions(), aRequestedPermissions);
    }

    private void initializePermissionTable(Hashtable aTable, String[] aPermissions, Vector aRequested) {
        int n = aPermissions.length;
        int i = 0;
        while (i < n) {
            String permission = aPermissions[i];
            if (aRequested.contains(permission)) {
                aTable.put(permission, permission);
            }
            ++i;
        }
    }
}

